# .bash_profile

# Get the aliases and functions
if [ -f ~/.bashrc ]; then
        . ~/.bashrc
fi

# User specific environment and startup programs
PATH=$PATH:$HOME/bin 

# Directory where the software to be installed is located
SOFTWARE_DIRECTORY="/installs"
export SOFTWARE_DIRECTORY

# Base directory
BASE_DIRECTORY="/u01/app"
export BASE_DIRECTORY
 
# Directory where the JVM will be installed
JAVA_HOME="/usr/java/jdk1.8.0_112"
export JAVA_HOME

 
# Directory where the configuration will be placed
CONFIGURATION_HOME="${BASE_DIRECTORY}"
export CONFIGURATION_HOME

export TOOLS_URI=http://vapcpappmhvcm82.tmc.va.gov/tools
export TOMCAT_VERSION=7.0.62
export LIFERAY_BASE_VERSION=6.2-ee-sp16
export LIFERAY_VERSION=$LIFERAY_BASE_VERSION-20161013140734110
export LIFERAY_WARFILE=liferay-portal-$LIFERAY_VERSION.war
export LIFERAY_DEPS=liferay-portal-dependencies-$LIFERAY_VERSION.zip
export LIFERAY_TOMCAT_BUNDLE=liferay-portal-tomcat-$LIFERAY_VERSION.zip
export LIFERAY_HOME=$BASE_DIRECTORY/liferay-portal-$LIFERAY_BASE_VERSION
export LIFERAY_TOMCAT_HOME=$LIFERAY_HOME/tomcat-$TOMCAT_VERSION
export LIFERAY_FOLDER=liferay-portal-$LIFERAY_BASE_VERSION


# Update the path for the user
export PATH=$JAVA_HOME/bin:$PATH

# Create handy aliases that I like!
alias ll="ls -la" 
